<?php

namespace VM\NotesBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Gedmo\Mapping\Annotation as Gedmo;

class UserNoteRepository extends EntityRepository
{
    /*
     * find notes and content for user
     */
    public function findForUser($studentId)
    {
        $QueryBuilder = $this->createQueryBuilder('n')
            ->select('n.note_id','n.note_timestamp','d.note')
            ->leftJoin('VM\NotesBundle\Entity\NoteDetails','d',\Doctrine\ORM\Query\Expr\Join::WITH,'n.note_id = d.id')
            ->where('n.user_id = :user')
            ->setParameter('user',$studentId)
        ;

        return $QueryBuilder->getQuery()->getResult();
    }
}
